<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    //PAGINA PER LO SCARICAMENTO DEI FILE, PRENDE IN INPUT L'ID E POI FA SCARICARE IL FILE AGGIORNANDO IL CAMPO NUMERO_DOWNLOAD NEL DATABASE
    include "include/costanti.php";
    include "gUtil/DbManager.php";

    $id   = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
    $tipo = filter_input(INPUT_GET,"tipo",FILTER_SANITIZE_ADD_SLASHES);

    $geecomDb  = new DbManager($costantiDatabase);

    if($tipo=="file") {
        //i dati del database sono definiti nel file costanti.php
        $documento = $geecomDb->leggiSingolaRiga("geecD_documenti",$id);

        $queryUltimaVersione = "SELECT * FROM geecD_versioniDocumento WHERE idDocumento = {$documento["id"]} ORDER BY id DESC LIMIT 1";
        $risUltimaVersione   = $geecomDb->eseguiQueryLettura($queryUltimaVersione);
        $datiUltimaVersione  = $risUltimaVersione->fetch_assoc();

        $numeroDownload = $datiUltimaVersione['numeroDownload'];
        $numeroDownload ++; //il file sta per essere scaricato un'altra volta quindi lo incremento di uno

        $queryAggiornamento = "UPDATE geecD_versioniDocumento SET numeroDownload='$numeroDownload' WHERE id='{$datiUltimaVersione["id"]}'";
        $geecomDb->eseguiQueryScrittura($queryAggiornamento);
        $nomeDocumento = substr(pathinfo($datiUltimaVersione["percorsoFile"], PATHINFO_FILENAME).".".pathinfo($datiUltimaVersione["percorsoFile"],PATHINFO_EXTENSION), 13);

        header('Content-type: octet/stream');
        header('Content-disposition: attachment; filename='.$nomeDocumento.';');
        header('Content-Length: '.filesize($datiUltimaVersione['percorsoFile']));
        readfile($datiUltimaVersione['percorsoFile']);
    }
    else { // zipCartella
        $cartella = $geecomDb->leggiSingolaRiga("geecD_cartelle",$id);
        
        $nomeArchivio         = str_replace(" ","",$cartelle["nome"]).date("mdY").".zip";
        $percorsoDestinazione = "file/archiviCartelle/$nomeArchivio";
        $zipArchive = new ZipArchive();
        $zipArchive->open($percorsoDestinazione, ZipArchive::CREATE);
        
        $queryDocumenti = "SELECT * FROM geecD_documenti WHERE cartella = {$cartella["id"]}";
        $risDocumenti   = $geecomDb->eseguiQueryLettura($queryDocumenti);
        while($documento = $risDocumenti->fetch_assoc()) {
            $queryUltimaVersione = "SELECT * FROM geecD_versioniDocumento WHERE idDocumento = {$documento["id"]} ORDER BY id DESC LIMIT 1";
            $risUltimaVersione   = $geecomDb->eseguiQueryLettura($queryUltimaVersione);
            $datiUltimaVersione  = $risUltimaVersione->fetch_assoc();
            
            $zipArchive->addFile($datiUltimaVersione["percorsoFile"]);
        }
        $zipArchive->close();
        header("Location: file/archiviCartelle/$nomeArchivio");
    }